Write-Host "Installing DataSync"

# Unblock files from the zip
Get-ChildItem -Path "." -Recurse | Unblock-File

# Check if the service exists
$serviceName = "Dispatch.WorkerServiceClient"
$service = Get-Service -Name $serviceName -ErrorAction SilentlyContinue

if ($null -eq $service) {
    Write-Host "Service not found. Running first-time installation steps..."

    # Authenticate the user first
    Start-Process -Wait -WorkingDirectory "console" -FilePath "consoleclient.exe" -ArgumentList "token --auth"

    # Run the MSI installer
    $exitCode = Start-Process -Wait -WorkingDirectory "service" -FilePath "DatasyncInstaller.msi"

    # Resolve full path to token cache
    $tokenPath = Join-Path -Path $PSScriptRoot -ChildPath "console\msal_token_cache.bin"
    $servicePath = (Get-CimInstance Win32_Service -Filter "Name = '$serviceName'").PathName.Trim('"')
    $targetPath = Split-Path $servicePath -Parent

    # Build elevated script with absolute paths
    $elevatedScript = @"
Copy-Item -Path `"$tokenPath`" -Destination `"$targetPath`" -Force
Start-Service -Name $serviceName
"@

    # Save and execute elevated
    $tempScriptPath = "$env:TEMP\copy-elevated.ps1"
    $elevatedScript | Set-Content -Path $tempScriptPath -Encoding UTF8
    Start-Process powershell.exe -ArgumentList "-NoProfile", "-ExecutionPolicy", "Bypass", "-File", "`"$tempScriptPath`"" -Verb RunAs -Wait
    Remove-Item $tempScriptPath -Force

} else {
    Write-Host "Service already exists. Running MSI installer only..."
    Start-Process -Wait -WorkingDirectory "service" -FilePath "DatasyncInstaller.msi"
}

Write-Host "DataSync installation done"